IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_BancoMacro_TX') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_BancoMacro_TX
END
GO

CREATE FUNCTION [dbo].[CF_BancoMacro_TX](@pId_Trans INT, @pImporte DECIMAL(12,2), @pId_Tar_Lote INT) 
RETURNS CHAR(220)
AS
BEGIN

/*Variable de Retorno*/
DECLARE @Retorno			CHAR(220)
/*FIN Variable de Retorno*/

/*Variables del Archivo*/
DECLARE @FillerInicio		CHAR(1) /*Relleno.  informar '0' cero*/
DECLARE @NroConvenio		CHAR(5) /*Numero de convenio en COBIS. obligatorio*/
DECLARE @NroServicio		CHAR(10)/*Numero de servicio en COBIS. obligatorio. De no existir informar blancos*/
DECLARE @NroEmpresaSueldos	CHAR(5) /*Numero de convenio AS en COBIS. obligatorio. De no existir informar ceros*/
DECLARE @CodBancoAdherente	CHAR(3) /*Codigo de Banco asignado por BCRA. obligatorio*/
DECLARE @CodSucursalCuenta	CHAR(4) /*Codigo de sucursal. Para Banco Macro  informar el numero de sucursal. Para otros bancos, informar las posiciones 4 a 7 del bloque 1 De la CBU*/
DECLARE @TipoCuenta			CHAR(1) /*Tipo de cuenta COBIS. 3 - Cta Cte ,  4 - Caja de Ahorros para cuentas de Banco Macro - Bansud. Para cuentas de otros bancos no informar*/
DECLARE @CtaBancariaAdhere	CHAR(15)/*Cuenta COBIS del adherente. Para Bco Macro informar el numero de cuenta. Para otros bancos, informar el bloque 2 De la CBU y rellenar con un cero a izquierda.*/
DECLARE @IdActualAdhere		CHAR(22)/*Identif. Del cliente con la empresa. obligatorio*/
DECLARE @IdDebito			CHAR(15)/*Numero de factura  / recibo identif. obligatorio Identificacion del Comprobante*/
DECLARE @FuncionUsoMovim	CHAR(2) /*identifica la transaccion a efectuar. informar blancos*/
DECLARE @CodMovimRechazo	CHAR(4) /*obligatorio para rechazos. informar blancos*/
DECLARE @FechaVencimiento	CHAR(8) /*Fecha aplicación / ABM. Obligatoria*/
DECLARE @MonedaDebito		CHAR(3) /*Moneda a debitar / debitada. 002 Dolares 080 Pesos*/
DECLARE @ImporteDebitar		CHAR(13)/*importe de la transaccion. No Informar punto decimal*/
DECLARE @FechaReintentoTope CHAR(8) /*Informar Ceros*/
DECLARE @ImporteDebitado	CHAR(13)/*Informar Ceros*/
DECLARE @NuevaSucBancaria	CHAR(4) /*Codigo de sucursal nueva. Informar Ceros*/
DECLARE @TipoCuentaB		CHAR(1) /*Tipo de cuenta COBIS. Informar Ceros*/
DECLARE @NuevaCuentaBanc	CHAR(15)/*Nueva cuenta COBIS del adherente. Informar Ceros*/
DECLARE @NuevaIdAdherente	CHAR(22)/*Nueva Identificacion Del cliente. Infromar Blancos*/
DECLARE @DatosRetorno		CHAR(40)/*Informar Blancos*/
DECLARE @SinUso				CHAR(5) /*Informar Blancos*/
DECLARE @FillerFin			CHAR(1) /*Relleno. Inforar '0' Cero*/

/*FIN Variables del Archivo*/

/*Variables Intermedias*/
DECLARE @Tar_Nro					VARCHAR(22)
DECLARE @Item						INT
DECLARE @Id_Banco_Macro				VARCHAR(10)
DECLARE @Id_Cliente					INT
DECLARE @CBU_PrimerBloque_IdBanco	CHAR(3)
DECLARE @CBU_PrimerBloque_IdSuc		CHAR(4)
DECLARE @CBU_SegundBloque_Cuenta	CHAR(13)
DECLARE @CBU_SegundBloque_DigVerifC CHAR(1)
DECLARE @Separador					CHAR(1)
DECLARE @FormatoExportacion			TINYINT

/*FIN Variables Intermedias*/

/* Modo de exportacion del archivo */

SET @FormatoExportacion = ISNULL((SELECT Valor_Integer FROM xParametros WHERE IdParametro = 'Id_Ban_Macro_Ver'),0)

/*Calculos intermerdios*/

SELECT	@Tar_Nro		= ISNULL(Nro, ''),
		@Item			= ISNULL(Item, 0) 
		FROM Val_Tarjetas_Lotes_Items 
		WHERE Id_Tar_Lote = @pId_Tar_Lote 
		AND Id_Trans = @pId_Trans

SET @Id_Banco_Macro				= ISNULL((SELECT Valor_String FROM xParametros WHERE IdParametro = 'Id_BancoMacro'),'')
SET @Id_Cliente					= (SELECT Id_Cliente FROM Cbtes WHERE Id_Trans = @pId_Trans)

IF(@FormatoExportacion = 1)
BEGIN
	SET @CBU_PrimerBloque_IdSuc		= (SELECT RIGHT ('0' + CAST(SUBSTRING(@Tar_Nro,5,3) AS VARCHAR), 4))
END
ELSE
BEGIN
	SET @CBU_PrimerBloque_IdSuc		= (SELECT RIGHT ('0' + CAST(SUBSTRING(@Tar_Nro,5,4) AS VARCHAR), 4))
END

SET @CBU_PrimerBloque_IdBanco	= (SELECT CAST(SUBSTRING(@Tar_Nro,1,3) AS CHAR(3)))

IF(@FormatoExportacion = 1)
BEGIN
	SET @CBU_SegundBloque_Cuenta	= (SELECT CAST(SUBSTRING(@Tar_Nro,11,11) AS CHAR(11))) -- SE MODIFICA POR TICKET #000400 EL 11/01/2022
END
ELSE
BEGIN
	SET @CBU_SegundBloque_Cuenta	= (SELECT CAST(SUBSTRING(@Tar_Nro,9,13) AS CHAR(13)))
END

SET @CBU_SegundBloque_DigVerifC	= (SELECT CAST(SUBSTRING(@Tar_Nro,22,1) AS CHAR(1)))
SET @TipoCuenta					= (SELECT CAST(SUBSTRING(@Tar_Nro,9,10) AS CHAR(1)))

/* FIN Calculos intermerdios*/

/*Grabacion de los campos de la fila*/
SET @FillerInicio		= '0'
SET @NroConvenio		= (SELECT LEFT(CAST(Comercio_Nro AS VARCHAR) + '00000', 5) FROM Valores_Tarjetas_Cred WHERE  Id_Tarjeta = @Id_Banco_Macro)	
SET @NroServicio		= ISNULL((SELECT Valor_String FROM xParametros WHERE IdParametro = 'BcoMacro_Servicio'),'          ')
SET @NroEmpresaSueldos	= (SELECT ISNULL(CONVERT(CHAR(5),Valor_Integer),'00000') FROM xParametros WHERE IdParametro = 'BcoMacro_Servicio')
SET @CodBancoAdherente	= @CBU_PrimerBloque_IdBanco
SET @CodSucursalCuenta	= @CBU_PrimerBloque_IdSuc

----------------------------------------------Se agrega tipo de cuenta pedido ticket 24126-----------------------------------------------------------------------
IF (@CBU_PrimerBloque_IdBanco = '285') /*285 = Cód. Banco Macro*/
BEGIN
	IF (@TipoCuenta = 3 OR @TipoCuenta = 4) /*3 - Cta. Cte. ,  4 - Caja de Ahorros*/
	BEGIN
		SET @TipoCuenta	= @TipoCuenta
	END 
END
ELSE
	BEGIN
		SET @TipoCuenta	= ' '/*No se informa*/
	END
------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@FormatoExportacion = 1)
BEGIN
	SET @CtaBancariaAdhere	= @TipoCuenta + (SELECT RIGHT (CAST(SUBSTRING(@Tar_Nro,5,3) AS VARCHAR), 4)) + @CBU_SegundBloque_Cuenta -- SE MODIFICA POR TICKET #000400 EL 11/01/2022
END
ELSE
BEGIN
	SET @CtaBancariaAdhere	= '0' + @CBU_SegundBloque_Cuenta + @CBU_SegundBloque_DigVerifC
END

SET @IdActualAdhere		= (SELECT LEFT(CAST(Id_Cliente AS VARCHAR) + '                      ', 22) FROM Cbtes WHERE Id_Trans = @pId_Trans)
SET @IdDebito			= (SELECT LEFT(CAST(Id_Trans AS VARCHAR) + '               ', 15) FROM Cbtes WHERE Id_Trans = @pId_Trans)
SET @FuncionUsoMovim	= '  '
SET @CodMovimRechazo	= '    '
--SET @FechaVencimiento	= (SELECT CAST(DATEPART(YY,Fecha_Venc) AS CHAR(4)) + 
--						   RIGHT('00' + CAST(DATEPART(mm,Fecha_Venc) AS VARCHAR),2) + 
--						   RIGHT('00' + CAST(DATEPART(dd,Fecha_Venc) AS VARCHAR),2) 
--						   FROM Cbtes WHERE Id_Trans = @pId_Trans)
------------------------------------------------------------------------------------------------------------------------------------------------------------------
SET @FechaVencimiento	= (SELECT CAST(DATEPART(YY,Fecha) AS CHAR(4)) +					 /*Se modifica la fecha venc para que tome la de Val_Tarjetas_Lotes_Items*/
						   RIGHT('00' + CAST(DATEPART(mm,Fecha) AS VARCHAR),2) + 
						   RIGHT('00' + CAST(DATEPART(dd,Fecha) AS VARCHAR),2)  
						   FROM Val_Tarjetas_Lotes WHERE Id_Tar_Lote = @pId_Tar_Lote)

------------------------------------------------------------------------------------------------------------------------------------------------------------------

SET @MonedaDebito		= '080' /*Siempre Pesos*/
SET @ImporteDebitar		=	RIGHT( '0000000000000' + CAST(CAST(@pImporte * 100 AS INT) AS VARCHAR), 13) 
SET @FechaReintentoTope = '00000000'
SET @ImporteDebitado	= '0000000000000'
SET @NuevaSucBancaria	= '0000'
SET @TipoCuentaB		= '0'
SET @NuevaCuentaBanc	= '000000000000000'
SET @NuevaIdAdherente	= '                      '
SET @DatosRetorno		= '                                        '
SET @SinUso				= '     '
SET @FillerFin			= '0'

/*FIN Grabacion de los campos de la fila*/

SET @Retorno			=			@FillerInicio
							+ @NroConvenio
							+ @NroServicio
							+ @NroEmpresaSueldos
							+ @CodBancoAdherente
							+ @CodSucursalCuenta
							+ @TipoCuenta
							+ @CtaBancariaAdhere
							+ @IdActualAdhere
							+ @IdDebito
							+ @FuncionUsoMovim
							+ @CodMovimRechazo
							+ @FechaVencimiento
							+ @MonedaDebito
							+ @ImporteDebitar
							+ @FechaReintentoTope
							+ @ImporteDebitado
							+ @NuevaSucBancaria
							+ @TipoCuentaB
							+ @NuevaCuentaBanc
							+ @NuevaIdAdherente
							+ @DatosRetorno
							+ @SinUso
							+ @FillerFin



RETURN @Retorno
END